%function [x_axis,y_axis,z_axis] = get_Vbias_Vg
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the voltage bias amplification
prompt_Vbias = 'enter the dc Vbias module amplification in Volts';
dlgtitle_Vbias = 'Input';
user_val_Vbias = inputdlg(prompt_Vbias,dlgtitle_Vbias);
Vbias_val = str2num(user_val_Vbias{1});

%% ask for the lockin amplification
prompt_Vac = 'enter lockin amplification in Volts';
dlgtitle_Vac = 'Input';
user_val_Vac = inputdlg(prompt_Vac,dlgtitle_Vac);
Vac_val = str2num(user_val_Vac{1});

%% ask for the factor to convert Bx to Btot
prompt_Bx = 'enter the factor for converting Bx (T) to B (T)';
dlgtitle_Bx = 'Input';
user_val_Bx = inputdlg(prompt_Bx,dlgtitle_Bx);
Bx_val = str2num(user_val_Bx{1});

%% ask for the measured voltage amplification
prompt_Vmeas = 'enter the amplification for measured voltage in Volts';
dlgtitle_Vmeas = 'Input';
user_val_Vmeas = inputdlg(prompt_Vmeas,dlgtitle_Vmeas);
Vmeas_val = str2num(user_val_Vmeas{1});

%% ask for the measured current amplification
prompt_Imeas = 'enter the amplification for measured current in Amps';
dlgtitle_Imeas = 'Input';
user_val_Imeas = inputdlg(prompt_Imeas,dlgtitle_Imeas);
Imeas_val = str2num(user_val_Imeas{1});

%% Reading the size of Vbias 
str_Vbias = char(file.textdata(6));
str_split = strsplit(str_Vbias);
size_Vbias = str2num(str_split{3});

%% Getting Vbias values
Vbias = file.data(1:size_Vbias,1)*Vbias_val;

%% Reading the size of Bx
size_Bx = size(file.data(:,1))/size_Vbias;

%% Getting the Bx values
r=1;
for i=1:size_Bx(1)
    Bx(i)=file.data(r,2);
    r=r+size_Vbias;
end

%% Getting measured Voltage values (across the device) and measured current values
s=1;
Vmeasure = zeros(size_Vbias,size_Bx(1));
Imeasure = zeros(size_Vbias,size_Bx(1));
for i=1:size_Bx(1)
    Vmeasure(1:size_Vbias,i)=file.data(s:s+size_Vbias-1,6)*Vmeas_val;
    Imeasure(1:size_Vbias,i)=file.data(s:s+size_Vbias-1,7)*Imeas_val;%lockinX value
    s=s+size_Vbias;
end

%% calculating the differential conductance in SI units
dIdV = Imeasure/Vac_val;

figure;
%G0 = 2*((1.6*10^-19)^2)/(6.62607015*10^-34);
x_axis = Bx/Bx_val;
y_axis = Vbias(2:end-1)*10^6;% in uV
z_axis = transpose(dIdV(:,2:end-1));
figure1 = pcolor(x_axis,Vmeasure(2:end-1,:)*10^3,dIdV(2:end-1,:));
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
%caxis([2.1*10^-6 2.2*10^-6])
% cl.Ticks = [2.1*10^-6 2.12*10^-6 2.14*10^-6 2.16*10^-6 2.18*10^-6 2.2*10^-6];
cl.Label.String = 'G (S)';
xlabel('$B_{||}(T)$','Interpreter','latex')
ylabel('$V_{bias}(mV)$','Interpreter','latex');

%end